%%% Spectrogram %%%

clear
close all

% Czstotliwo prbkowania
Fs=2000;

tp=1/Fs;

% Czas analizy sygnau
t=0:tp:2; % czestotliwosc probkowania Fs=2000Hz; czas koncowy tk=2s

% Analizowany Sygna
% t0 odpowiada f=100Hz; t=1s odpowiada f=300Hz
y=chirp(t,100,1,300,'quadratic');

M=length(y);

% Obliczenie widma
wid=abs(fft(y));
N=length(wid);
wid(1)=wid(1)/N;
wid(2:end)=wid(2:end)./(N/2);

df=Fs/N;
fprintf('Rozdzielczo analizy = %1.2f Hz\n',df);
f=0:df:(Fs-df);

figure(1)

subplot(211)
%plot(t,y,'b');
plot(t(1:1000),y(1:1000),'b');
axis tight;
grid on
xlabel('Czas')
ylabel('Amplituda')
title('Sygnal')

subplot(212)
stem(f(1:fix(N/2)),wid(1:fix(N/2)),'.');
axis tight;
grid on
xlabel('Czestotliwosc')
ylabel('Amplituda')
title('Widmo')

figure(2)
% Obliczenie spektrogramu
spectrogram(y,256,250,256,Fs,'yaxis');




